jQuery(document).ready(function($) {
      "use strict";

      // fixed header
      $('.theme-header').affix({
            offset: {
              top: $('header').height()
            }
      });   

      // main menu smooth scroll

      $('.main-nav a[href*=#]:not([href=#])').on('click', function(){
        if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
            var target = $(this.hash);
            target = target.length ? target : $('[name=' + this.hash.slice(1) +']');
            if (target.length) {
              $('html,body').animate({
                scrollTop: target.offset().top
              }, 1000);
              return false;
            }
          }
      });

      // Home Slider 1

      if ($.fn.sliderPro) {
        if ($('#index-slider2').length >= 0) {
          $('#index-slider2').fadeIn(3000);
          $('#index-slider2').sliderPro({
            width: 1920,
            height: 810,
            visibleSize: '100%',
            forceSize: 'fullWidth',
            arrows: true,
            autoplay: true,
            autoplayDelay: 8500,
            autoplayOnHover: 'none',
            slideDistance: 0,
            buttons: false
          });
        };
      }

      // owl carousel
      if ($.fn.owlCarousel) {

        // service-slider
        if ($('#service-slider').length >= 0) {
          $('#service-slider').owlCarousel({
            loop: true,
            items: 4,
            margin: 0,
            autoplay: true,
            dots:true,
            nav: true,
            navText: ['<i class="fa flaticon-arrows-1"></i>','<i class="fa flaticon-arrows"></i>'],
            autoplayTimeout: 8500,
            smartSpeed: 450,
            responsive: {
              0: {
                items: 1
              },
              768: {
                items: 3
              },
              1170: {
                items: 4
              }
            }
          });
        };

        // gallery slider
        if ($('#gallery-slider').length >= 0) {
          $('#gallery-slider').owlCarousel({
            loop: true,
            items: 1,
            singleItem: true,
            margin: 0,
            autoplay: true,
            dots:true,
            nav: true,
            navText: ['<i class="fa flaticon-arrows-1"></i>','<i class="fa flaticon-arrows"></i>'],
            autoplayTimeout: 8500,
            smartSpeed: 450
          });
        };

        // testimonial slider
        if ($('#testimonial-slider').length >= 0) {
          $('#testimonial-slider').owlCarousel({
            loop: true,
            items: 1,
            singleItem: true,
            margin: 0,
            autoplay: true,
            dots:false,
            nav: true,
            navText: ['<i class="fa flaticon-arrows-1"></i>','<i class="fa flaticon-arrows"></i>'],
            autoplayTimeout: 8500,
            smartSpeed: 450
          });
        };
      }


      // Magnific-Popup

      if ($.fn.magnificPopup) {
        if ($('.image-popup').length >= 0) {
          $('.image-popup').magnificPopup({type:'image'});
        };
      }

});